// This header file contains the IOCTL definitions.  By placing their
// definitions in a header file, other programs are able to access and
// use them more easily.
//

#ifndef _hprf_h
#define _hprf_h

#include <winioctl.h>
#include <windows.h>
#include <ceddk.h>


// Needed for constants used in rfparam structure
#include "hprfgw_rfRec.h"
#include "hprfgw_rfRetry.h"
#include "hprfgw_rfApp.h"

#include "hprf.h"
#include "HprfInterface.h"

/////////////////////////////////
/// Global Function declarations
DWORD SendCtrlMsgToApp(PVOID lpBuffer, DWORD cbDataSize);
DWORD SendCresnetPacketToApp(PVOID lpBuffer, DWORD cbDataSize);
DWORD SendLocalCresnetPacketToApp(PVOID lpBuffer, DWORD cbDataSize);
DWORD SendDiagDataToApp(PVOID lpBuffer, DWORD cbDataSize);

///////////////////////////////////////
/// SPI bus config

#define HPR_SPI_BUS                         TEXT("SPI1:")   /* SPI bus based on the schematic and the platform.reg index */
#define HPR_SPI_CS                          CSPI_CS1        /* On what Chip select is the device */
#define HPR_SPI_FREQ                        6000000         /* 6 Mhz */

// Memory configuration for HPR device - not used
//#define HPR_INITIAL_HEAP_SIZE				(1024 * 1024)	/* 1 MB for now */
//#define HPR_MAX_HEAP_SIZE					(HPR_INITIAL_HEAP_SIZE * 2)

typedef struct _hprf_hw_dev
{
    HANDLE  hGPIO;
    HANDLE  hSPI;  
    DWORD   dwHprfIntrId;
    DWORD   dwHprfSysintr;
    HANDLE  hHprfIntrEvent;
    BOOL    intrThreadExit;
    HANDLE  hHprfIntrThread;
    HANDLE  RF_Rx_Queue_write;
    HANDLE  RF_Rx_Queue2_write;
    HANDLE  RF_Tx_Queue_read;
    HANDLE  RF_Tx_Queue2_read;
    HANDLE  RF_Cntrl_Queue_write;
    HANDLE  RF_Diag_Queue_write;
    HANDLE  hRFTx_CresnetPacketThread;
    HANDLE  hRFTx_LocalCresnetPacketThread;
    HANDLE  hRF_LQIThread;
    HANDLE  hLQIEvent;
    BOOL    bApplicationInitDone;
    CEDEVICE_POWER_STATE powerState;
    DWORD   dwPowerDown;
} hprf_hw_dev;

///////////////////////////////////////
// Exteranal variables
extern hprf_hw_dev *pHPRDevice;
extern HANDLE hprSystemMemoryPool;
extern CHAR bootidmsg[128];

///////////////////////////////////////
/// Constants used in winceIntfc.c file

// Application related Thread priorities
#define RFTX_CRESNET_PACKET_TASK_PRIORITY           (RF_TASKS_BASE_PRIORITY + 10)
#define RFTX_LOCAL_CRESNET_PACKET_TASK_PRIORITY     (RF_TASKS_BASE_PRIORITY + 20)

// Constants for LQI handler
#define RF_LQI_TASK_PRIORITY                        (RF_TASKS_BASE_PRIORITY + 25)
#define RF_LQI_TASK_STACK_SIZE                      (8 * 1024)
#define RF_LQI_INTERVAL_MS                          1000        // Task interval in ms

///////////////////////////////////////
// Pin configurations (Pin names are from
// the schematics
/*
 PAEN   (input to radio)	: B9 (PATA_DATA0) 
 *RXEN  (input to radio)	: C5 (PATA_DATA3)
 *TX_EN (input to radio)	: V3 (PATA_DATA5)
 RXTXEN (input to radio)	: B8 (PATA_DATA1)
 *ATTN  (input to radio)	: B6 (PATA_DATA2)
 *RESET (input to radio)	: V2 (PATA_DATA6)
 *IRQ   (output from radio)	: V1 (PATA_DATA15)

 ID01   (FCC Id bit)		: W1 (PATA_DATA14)
 ID02   (FCC Id bit)		: AA1(PATA_DATA13)
 ID03   (FCC Id bit)		: Y1 (PATA_DATA12)

 PWR    (Radio Power ON)	: W2 (PATA_DATA7)
*/

// All HPRF Signals are on GPIO Instance 2 (so just one define is fine)
#define HPRF_GPIO_PORT			DDK_GPIO_PORT2

// Following represents the pin (bit) numbers in the GPIO port.
// Signal names are from the schematics
#define HPRF_GPIONUM_PAEN       0	/* Signal name RF_PA_EN */
#define HPRF_GPIONUM_N_RXEN     3	/* Signal name RF_RXEN */
#define HPRF_GPIONUM_N_TX_EN    5	/* Signal name RF_TXEN */
#define HPRF_GPIONUM_RXTXEN     1	/* Signal name RF_RXTX_EN */
#define HPRF_GPIONUM_N_ATTN     2	/* Signal name RF_ATTN_N */
#define HPRF_GPIONUM_N_RESET    6	/* Signal name RF_RESET_N */
#define HPRF_GPIONUM_N_IRQ      15	/* Signal name RF_INT_N */

#define HPRF_GPIONUM_FCC_ID01	14	/* Signal name RF_ID0 */
#define HPRF_GPIONUM_FCC_ID02	13	/* Signal name RF_ID1 */
#define HPRF_GPIONUM_FCC_ID03	12	/* Signal name RF_ID2 */

#define HPRF_GPIONUM_RADIO_ON	7	/* Signal name HP_RF_ON */

// IRQ ID to register with OS Kernel
#define HPRF_IRQ_ID	        IRQ_GPIO2_PIN15

////////////////////////////////////////
// Other constant defines
#define RF_BOOT_ID_STRING_DEFAULT   "TSX [v0.000.0000, #00000000]"	// original = "TST-600 [v3.001.0000, #00000000]"


////////////////////////////////////////

// Registry Path
#define HPRF_REGISTRYENTRY (L"SOFTWARE\\Crestron\\iSysio\\Settings\\Radio")

//Settings required to be in non-erasable.
#define UID_SIGN         0xD00F
// UID in the registry is just for human-read purpose. Driver has nothing to do with it.
#define KEY_UID                         L"UID"

/////////////////////////////////////////////////////////////////////////
// Registry keys. Strings should match what is defined in project.reg file
#define KEY_PANID                       L"panID"
#define KEY_SHORT_ADDRESS               L"shortAddr"
#define KEY_ADDRESS_MODE                L"addrMode"
#define KEY_CCA_ENERGY_DETECT_THR       L"CCAEnergyDetectThr"
#define KEY_RSSI_PWR_COMP_OFFSET        L"RSSIPowerCompOffset"
#define KEY_RF_CHANNEL                  L"channel"
#define KEY_RF_POWER                    L"power"
#define KEY_RETRY                       L"retry"
#define KEY_RETRY_DELAY                 L"retrydelay"
#define KEY_RESULT_CODE_TIMEOUT         L"resultcodetimeout"
#define KEY_HEART_BEAT                  L"heartBeat"
#define KEY_LINK_RETRY_DELAY            L"link_retrydelay"
#define KEY_GATEWAY_UID                 L"gatewayUID"
#define KEY_GATEWAY_PANID               L"gatewayPanID"
#define KEY_RF_ID                       L"RFID"
#define KEY_RF_TX_DEBUG                 L"RFTxDebug"
#define KEY_RF_RX_DEBUG                 L"RFRxDebug"
#define KEY_RF_GENERIC_DEBUG            L"RFGenericDebug"
#define KEY_RF_POWER_HI_LO              L"powerhilo"
#define KEY_LINK_LQI_THR                L"LinkLQIThreshold"
#define KEY_TX_PKT_RETRY_ON_CONN        L"txPktretryonconnection"
#define KEY_PRE_LINK_QUERY_PKT_COUNT    L"PreLinkQueryPacketCnt"
#define KEY_POWER_BOOST                 L"powerBoost"

//////////////////////////////////////////////////////////////////////
// This strucutre is synchronized with the registry settings
typedef struct
{
    UINT8   UID[UID_MAX_SIZE];
    UINT16  panID;                    //default=TBD                         
    UINT16  shortAddr;                //default=0xFFFE; 
    UINT8   addrMode;                 //default=3;          
    UINT8   CCAEnergyDetectThr;       //default=TBD, for new set to 0x40
    UINT8   RSSIPowerCompOffset;      //    default=0x74
    UINT8   channel;                  //default=26;                 
    UINT16  power;                    //default=0xFFFF;  (THIS IS NOT USED)
    UINT8   retry;                    //default=3;
    UINT8   retrydelay[RF_MAX_NO_OF_RETRIES_DELAYS];
    UINT16  resultcodetimeout;        //default=2;  (1-second)
    UINT8   heartBeat;                //default=4;  (40-second) (1 count is 10-second)      
    UINT8   link_retrydelay[RF_MAX_NO_OF_RETRIES_DELAYS]; // NOTE HS must fix this. Not defined
    UINT8   gatewayUID[UID_MAX_SIZE];// Obtained from acquire process
    UINT16  gatewayPanID;            // Obtained from acquire process
    UINT8   RFID;   
    UINT8   RFTxDebug;               // RF transmit trace debug 
    UINT8   RFRxDebug;               // RF receive trace debug
    UINT8   RFGenericDebug;          // RF transmit trace debug 
    UINT8   powerhilo;
    UINT8   LinkLQIThreshold;        // Link LQI threshold (this was a spare before)
    UINT8   txPktretryonconnection;  // New param 11/3/2007 11:07PM
    UINT8   PreLinkQueryPacketCnt;   // New param 11/3/2007 11:08PM
    UINT8   powerBoost;				 // add this boost to the high power
} RF_PARAM;
extern RF_PARAM rfparam;

///// Add local parameters only, not stored in the registry /////
typedef struct
{
    INT8   gatewayUIDString[RF_DEVICE_MAX_CRESNET_ID_STRING_LEN];
    INT8   gatewayName[GATEWAY_NAME_MAX_SIZE];
    INT8   UIDString[RF_DEVICE_MAX_CRESNET_ID_STRING_LEN];
    UINT32 TSID;
    UINT32 UID_Valid;
}RF_PARAM_LOCAL;
extern RF_PARAM_LOCAL rfparamlocal;



/////////////////////////////////////////////////////////////////////////////////

#endif /*_hprf_h*/
